<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphTo;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Activity extends Model
{
    protected $fillable = [
        'user_id',
        'type',
        'subject_id',
        'subject_type',
        'description',
        'properties'
    ];

    protected $casts = [
        'properties' => 'array',
        'created_at' => 'datetime'
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function subject(): MorphTo
    {
        return $this->morphTo();
    }

    public function getHumanReadableAttribute(): string
    {
        $userName = $this->user->name ?? 'User';
        
        return match($this->type) {
            // TIMESHEET ACTIVITIES
            'timesheet_submitted' => "{$userName} submitted a timesheet",
            'timesheet_approved' => "{$userName}'s timesheet was approved",
            'timesheet_rejected' => "{$userName}'s timesheet was rejected",
            'timesheet_updated' => "{$userName} updated a timesheet",
            
            // VEHICLE ACTIVITIES  
            'vehicle_requested' => "{$userName} requested a vehicle",
            'vehicle_approved' => "{$userName}'s vehicle request was approved", 
            'vehicle_rejected' => "{$userName}'s vehicle request was rejected",
            'vehicle_returned' => "{$userName} returned a vehicle",
            'vehicle_updated' => "{$userName} updated vehicle booking",
            
            // EXPENSES CLAIM ACTIVITIES
            'expense_submitted' => "{$userName} submitted an expense claim",
            'expense_approved' => "{$userName}'s expense claim was approved",
            'expense_rejected' => "{$userName}'s expense claim was rejected",
            'expense_updated' => "{$userName} updated an expense claim",
            'expense_paid' => "{$userName}'s expense claim was paid",
            
            default => $this->description
        };
    }
}