<?php

namespace App\Models;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;

class User extends Authenticatable
{
    use HasFactory, Notifiable;

    /*protected $fillable = [
        'name',
        'email', 
        'password',
        'phone',
       // 'status'
    ];

    protected $hidden = [
        'password',
        'remember_token',
    ];*/

    
    protected $fillable = [
        'name', 
        'email', 
        'password', 
        'role'
    ];

    protected $hidden = [
        'password', 'remember_token',
    ];
    protected $attributes = [
       // 'status' => 'active',
    ];

    // Role Check Methods
    public function isAdmin()
    {
        return $this->role === 'admin';
    }

    public function isManager()
    {
        return $this->role === 'manager';
    }
    public function expenses()
    {
        return $this->hasMany(Expense::class);
    }

    public function isEditor()
    {
        return $this->role === 'editor';
    }

    public function hasRole($role)
    {
        return $this->role === $role;
    }

    public function hasAnyRole($roles)
    {
        return in_array($this->role, (array)$roles);
    }

    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
            'created_at' => 'datetime',
            'updated_at' => 'datetime',
        ];
    }
    public static function getVehicleUsageOptions()
    {
        return [
            'personal' => 'Personal Use',
            'business' => 'Business Use',
            'commercial' => 'Commercial Use',
            'ride_sharing' => 'Ride Sharing',
            'delivery' => 'Delivery Services',
        ];
    }

    // Accessor for safe date formatting
    public function getFormattedCreatedAtAttribute()
    {
        return $this->created_at ? $this->created_at->format('M d, Y') : 'N/A';
    }

    public function getFormattedUpdatedAtAttribute()
    {
        return $this->updated_at ? $this->updated_at->format('M d, Y') : 'N/A';
    }

    public function getJoinedDateAttribute()
    {
        return $this->created_at ? $this->created_at->format('M Y') : 'N/A';
    }

    // Accessor for safe phone display
    public function getDisplayPhoneAttribute()
    {
        return $this->phone ?? 'No phone';
    }

    // Accessor for initials
    public function getInitialsAttribute()
    {
        return strtoupper(substr($this->name, 0, 1));
    }
}