

<?php $__env->startSection('title', 'Time Sheet Details- Canindigo INC'); ?>
<?php $__env->startSection('page-title', 'Time Sheet Details'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-3xl mx-auto">
    <div class="bg-white rounded-lg shadow p-6">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <div>
                <h4 class="text-sm font-medium text-gray-500">Date</h4>
                <p class="mt-1 text-lg font-semibold text-gray-900"><?php echo e($timeSheet->date->format('F d, Y')); ?></p>
                <p class="text-sm text-gray-500"><?php echo e($timeSheet->date->format('l')); ?></p>
            </div>

            <div>
                <h4 class="text-sm font-medium text-gray-500">Project Code</h4>
                <p class="mt-1 text-lg font-semibold text-gray-900"><?php echo e($timeSheet->project_code); ?></p>
            </div>

            <div>
                <h4 class="text-sm font-medium text-gray-500">Time</h4>
                <p class="mt-1 text-lg font-semibold text-gray-900">
                    <?php echo e(date('g:i A', strtotime($timeSheet->start_time))); ?> - <?php echo e(date('g:i A', strtotime($timeSheet->end_time))); ?>

                </p>
                <p class="text-sm text-gray-500">Total: <?php echo e($timeSheet->total_hours); ?> hours</p>
            </div>

            <div>
                <h4 class="text-sm font-medium text-gray-500">Overtime Weekdays</h4>
                <p class="mt-1 text-lg font-semibold text-gray-900"><?php echo e($timeSheet->overtime_weekdays); ?> hours</p>
            </div>

            <div>
                <h4 class="text-sm font-medium text-gray-500">Overtime Weekend</h4>
                <p class="mt-1 text-lg font-semibold text-gray-900"><?php echo e($timeSheet->overtime_weekend); ?> hours</p>
            </div>

            <?php if($timeSheet->description): ?>
            <div class="md:col-span-2">
                <h4 class="text-sm font-medium text-gray-500">Description</h4>
                <p class="mt-1 text-gray-900"><?php echo e($timeSheet->description); ?></p>
            </div>
            <?php endif; ?>
        </div>

        <div class="mt-6 flex justify-end space-x-3">
            <a href="<?php echo e(route('time-sheets.index')); ?>" class="bg-gray-300 text-gray-700 px-4 py-2 rounded-lg hover:bg-gray-400">
                Back to List
            </a>
            <!-- <a href="<?php echo e(route('time-sheets.edit', $timeSheet)); ?>" class="bg-green-600 text-white px-4 py-2 rounded-lg hover:bg-green-700">
                Edit Entry
            </a> -->
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\xampp\htdocs\Scratch\resources\views/time-sheets/show.blade.php ENDPATH**/ ?>